<?php

/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://gdprdemo.willowdigital.com/
 * @since      1.0.0
 *
 * @package    gdpr_personal_data_reports
 * @subpackage gdpr_personal_data_reports/admin/partials
 */
?>

<!-- This file should primarily consist of HTML with a little bit of PHP. -->
<div class="wrap">
  <h2><?php echo esc_html(get_admin_page_title()); ?></h2>

  <ul class="nav gdprpdr_nav-tabs">
    <li class="gdprpdr_nav-item gdprpdr_active"><a class="gdprpdr_nav-link gdprpdr_active" href="#tab-1"><?php _e('General Settings', $this->gdpr_personal_data_reports) ?></a></li>
    <li class="gdprpdr_nav-item"><a class="gdprpdr_nav-link" href="#tab-2"><?php _e('GDPR User Fields', $this->gdpr_personal_data_reports) ?></a></li>
    <li class="gdprpdr_nav-item"><a class="gdprpdr_nav-link" href="#tab-3"><?php _e('GDPR Post Fields', $this->gdpr_personal_data_reports) ?></a></li>
    <li class="gdprpdr_nav-item"><a class="gdprpdr_nav-link" href="#tab-4"><?php _e('GDPR Request Log', $this->gdpr_personal_data_reports) ?></a></li>
  </ul>

  <form method="post" name="gdpr_personal_data_reports" action="options.php" enctype="multipart/form-data">

    <?php
      $options = get_option($this->gdpr_personal_data_reports);

      $user_meta_fields = $this->user_meta_fields;
      $post_meta_fields = $this->post_meta_fields;

      $gdpr_requests = $this->get_gdpr_requests();

      $other_locations = !empty($options['other_locations']) ? $options['other_locations'] : '';
      $physical_locations = !empty($options['physical_locations']) ? $options['physical_locations'] : '';
      $max_requests = !empty($options['max_requests']) ? $options['max_requests'] : '';
      $max_confirmation_attempts = !empty($options['max_confirmation_attempts']) ? $options['max_confirmation_attempts'] : 3;
      $max_requests_log = !empty($options['max_requests_log']) ? $options['max_requests_log'] : '';
      $header = !empty($options['header']) ? $options['header'] : '';
      $footer = !empty($options['footer']) ? $options['footer'] : '';
      $right_to_be_forgotten = !empty($options['right_to_be_forgotten']) ? 1 : 0;
    ?>

    <?php settings_fields($this->gdpr_personal_data_reports); ?>
    <?php do_settings_sections($this->gdpr_personal_data_reports); ?>

  <div class="gdprpdr_tab-content">
    <div id="tab-1" class="gdprpdr_tab-pane gdprpdr_active">
      <h3><?php _e('General Settings', $this->gdpr_personal_data_reports) ?></h3>

        <table class="form-table">
          <fieldset>
          <tr>
            <th scope="row"><legend class="screen-reader-text"><span><?php _e('Other locations/services where you store personal data', $this->gdpr_personal_data_reports) ?></span></legend><label for="<?php echo $this->gdpr_personal_data_reports; ?>-other_locations"><?php _e('Other locations/services where you store personal data', $this->gdpr_personal_data_reports) ?></label></th>
            <td><input type="text" id="<?php echo $this->gdpr_personal_data_reports; ?>-other_locations" name="<?php echo $this->gdpr_personal_data_reports; ?>[other_locations]" value="<?php if(!empty($other_locations)) echo $other_locations; ?>"/></td>
          </tr>
          </fieldset>

          <fieldset>
          <tr>
            <th scope="row"><legend class="screen-reader-text"><span><?php _e('Physical locations of servers where you host your website and other data', $this->gdpr_personal_data_reports) ?></span></legend><label for="<?php echo $this->gdpr_personal_data_reports; ?>-$physical_locations"><?php _e('Physical locations of servers where you host your website and other data', $this->gdpr_personal_data_reports) ?></label></th>
            <td><input type="text" id="<?php echo $this->gdpr_personal_data_reports; ?>-physical_locations" name="<?php echo $this->gdpr_personal_data_reports; ?>[physical_locations]" value="<?php if(!empty($physical_locations)) echo $physical_locations; ?>"/></td>
          </tr>
          </fieldset>

          <!-- Max requests per day -->
          <fieldset>
          <tr>
            <th scope="row"><legend class="screen-reader-text"><span><?php _e('Max Requests per Day', $this->gdpr_personal_data_reports) ?></span></legend><label for="<?php echo $this->gdpr_personal_data_reports; ?>-max_requests"><?php _e('Max Requests per Day', $this->gdpr_personal_data_reports) ?></label></th>
            <td><input type="number" id="<?php echo $this->gdpr_personal_data_reports; ?>-max_requests" name="<?php echo $this->gdpr_personal_data_reports; ?>[max_requests]" value="<?php if(!empty($max_requests)) echo $max_requests; ?>"/></td>
          </tr>
          </fieldset>

          <!-- Max confirmation attempts -->
          <fieldset>
          <tr>
            <th scope="row"><legend class="screen-reader-text"><span><?php _e('Max Confirmation Attempts', $this->gdpr_personal_data_reports) ?></span></legend><label for="<?php echo $this->gdpr_personal_data_reports; ?>-max_confirmation_attempts"><?php _e('Max Confirmation Attempts', $this->gdpr_personal_data_reports) ?></label></th>
            <td><input type="number" id="<?php echo $this->gdpr_personal_data_reports; ?>-max_confirmation_attempts" name="<?php echo $this->gdpr_personal_data_reports; ?>[max_confirmation_attempts]" value="<?php if(!empty($max_confirmation_attempts)) echo $max_confirmation_attempts; ?>"/></td>
          </tr>
          </fieldset>

          <fieldset>
          <tr>
            <th scope="row"><legend class="screen-reader-text"><span><?php _e('GDPR Email Header', $this->gdpr_personal_data_reports) ?></span></legend><label for="<?php echo $this->gdpr_personal_data_reports; ?>-header"><?php _e('GDPR Email Header', $this->gdpr_personal_data_reports) ?></label></th>
            <td><textarea style="resize:both;" type="text" id="<?php echo $this->gdpr_personal_data_reports; ?>-header" name="<?php echo $this->gdpr_personal_data_reports; ?>[header]"/><?php if(!empty($header)) echo $header; ?></textarea></td>
          </tr>
          </fieldset>

          <fieldset>
          <tr>
            <th scope="row"><legend class="screen-reader-text"><span><?php _e('GDPR Email Footer', $this->gdpr_personal_data_reports) ?></span></legend><label for="<?php echo $this->gdpr_personal_data_reports; ?>-footer"><?php _e('GDPR Email Footer', $this->gdpr_personal_data_reports) ?></label></th>
            <td><textarea style="resize:both;" id="<?php echo $this->gdpr_personal_data_reports; ?>-footer" name="<?php echo $this->gdpr_personal_data_reports; ?>[footer]"/><?php if(!empty($footer)) echo $footer; ?></textarea></td>
          </tr>
          </fieldset>

          <fieldset>
          <tr>
            <th scope="row"><legend class="screen-reader-text"><span><?php _e('Limit of Requests Displayed in the Log', $this->gdpr_personal_data_reports) ?></span></legend><label for="<?php echo $this->gdpr_personal_data_reports; ?>-max_requests_log"><?php _e('Limit of Requests Displayed in the Log', $this->gdpr_personal_data_reports) ?></label></th>
            <td><input type="number" id="<?php echo $this->gdpr_personal_data_reports; ?>-max_requests_log" name="<?php echo $this->gdpr_personal_data_reports; ?>[max_requests_log]" value="<?php if(!empty($max_requests_log)) echo $max_requests_log; ?>"/></td>
          </tr>
          </fieldset>

          <!-- Right to be forgotten -->
          <fieldset>
          <tr>
            <th scope="row"><legend class="screen-reader-text"><span><?php _e('Give customers "Right to be Forgotten"', $this->gdpr_personal_data_reports) ?></span></legend><label for="<?php echo $this->gdpr_personal_data_reports; ?>-right-to-be-forgotten"><?php _e('Give customers "Right to be Forgotten"', $this->gdpr_personal_data_reports) ?></label></th>
            <td><input type="checkbox" id="<?php echo $this->gdpr_personal_data_reports; ?>-right-to-be-forgotten" name="<?php echo $this->gdpr_personal_data_reports; ?>[right_to_be_forgotten]"
              <?php if($right_to_be_forgotten) echo("checked"); ?>/></td>
          </tr>
          </fieldset>

        </table>
    </div>

    <div id="tab-2" class="gdprpdr_tab-pane">
      <h3><?php _e('GDPR User Fields', $this->gdpr_personal_data_reports) ?></h3>
      <p><?php _e('Please select which user metadata fields include personal information and should be included in the GDPR report', $this->gdpr_personal_data_reports) ?></p>

      <?php
      //echo('<pre>');
      //var_dump($this->wp_usermeta);
      //var_dump($user_meta_fields);
      //var_dump(in_array('first_name', $this->wp_usermeta));
      //die();
      ?>


      <table class="form-table">
        <!-- For each user_meta field -->
        <?php foreach($user_meta_fields as $index => $user_field) { ?>
          <!-- Check default user_meta fields -->
          <?php if(in_array($user_field->meta_key, $this->wp_usermeta)) { ?>
            <?php
              $field_value = !empty($options['user_meta_fields'][$user_field->meta_key]['status']) ? $options['user_meta_fields'][$user_field->meta_key]['status'] : '0';
              $field_value_text = !empty($options['user_meta_fields'][$user_field->meta_key]['text']) ? $options['user_meta_fields'][$user_field->meta_key]['text'] : '';
              $value = !empty($options['user_meta_fields'][$user_field->meta_key]['status']) ? '1' : '0'
            ?>
            <fieldset>
            <tr>
              <th scope="row"><legend class="screen-reader-text"><span><?php echo(ucwords(str_replace('_', ' ', $user_field->meta_key))); ?></span></legend><label for="<?php echo $this->gdpr_personal_data_reports . "-" . $user_field->meta_key ?>"><?php echo(ucwords(str_replace('_', ' ', $user_field->meta_key))); ?></label></th>
              <td><input type="checkbox" id="<?php echo $this->gdpr_personal_data_reports . "-" . $user_field->meta_key ?>" name="<?php echo $this->gdpr_personal_data_reports; ?>[user_meta_fields][<?php echo($user_field->meta_key); ?>][status]"<?php if($field_value) echo("checked"); ?>/></td>
            </tr>
            </fieldset>

            <!-- Meta data keys translation -->
            <tr>
              <th scope="row"><legend class="screen-reader-text"><span><?php echo(ucwords(str_replace('_', ' ', $user_field->meta_key))); ?> <?php _e('Text', $this->gdpr_personal_data_reports) ?></span></legend><label for="<?php echo $this->gdpr_personal_data_reports . "-" . $user_field->meta_key ?>-text"><?php echo(ucwords(str_replace('_', ' ', $user_field->meta_key))); ?> <?php _e('Text', $this->gdpr_personal_data_reports) ?></label></th>
              <td><input type="text" id="<?php echo $this->gdpr_personal_data_reports . "-" . $user_field->meta_key ?>-text" name="<?php echo $this->gdpr_personal_data_reports; ?>[user_meta_fields][<?php echo($user_field->meta_key); ?>][text]" value="<?php if(!empty($field_value_text)) { echo $field_value_text; } else { echo(ucwords(str_replace('_', ' ', $user_field->meta_key))); }?>"/></td>
            </tr>
            <!-- Meta data keys translation -->
          <?php } ?>
          <!-- Check default user_meta fields end -->
        <?php } ?>
        <!-- For each user_meta end -->
      </table>
    </div>

    <div id="tab-3" class="gdprpdr_tab-pane">
      <h3><?php _e('GDPR Post Fields', $this->gdpr_personal_data_reports) ?></h3>
      <p><?php _e('Please select which post metadata fields should be included in the GDPR report', $this->gdpr_personal_data_reports) ?></p>

      <table class="form-table">
        <!-- For each post_meta_field -->
        <?php foreach($post_meta_fields as $index => $post_field) { ?>
          <!-- Check default post_meta fields -->
          <?php if(in_array($post_field->meta_key, $this->wp_postmeta)) { ?>
            <?php
              $field_value = !empty($options['post_meta_fields'][$post_field->meta_key]['status']) ? $options['post_meta_fields'][$post_field->meta_key]['status'] : '0';
              $field_value_text = !empty($options['post_meta_fields'][$post_field->meta_key]['text']) ? $options['post_meta_fields'][$post_field->meta_key]['text'] : '';
              $value = !empty($options['post_meta_fields'][$post_field->meta_key]['status']) ? '1' : '0'
            ?>
            <fieldset>
            <tr>
              <th scope="row"><legend class="screen-reader-text"><span><?php echo(ucwords(str_replace('_', ' ', $post_field->meta_key))); ?></span></legend><label for="<?php echo $this->gdpr_personal_data_reports . "-" . $post_field->meta_key ?>"><?php echo(ucwords(str_replace('_', ' ', $post_field->meta_key))); ?></label></th>
              <td><input type="checkbox" id="<?php echo $this->gdpr_personal_data_reports . "-" . $post_field->meta_key ?>" name="<?php echo $this->gdpr_personal_data_reports; ?>[post_meta_fields][<?php echo($post_field->meta_key); ?>][status]" <?php if($field_value) echo("checked"); ?>/></td>
            </tr>
            </fieldset>

            <!-- Meta data keys translation -->
            <tr>
              <th scope="row"><legend class="screen-reader-text"><span><?php echo(ucwords(str_replace('_', ' ', $post_field->meta_key))); ?> <?php _e('Text', $this->gdpr_personal_data_reports) ?></span></legend><label for="<?php echo $this->gdpr_personal_data_reports . "-" . $post_field->meta_key ?>-text"><?php echo(ucwords(str_replace('_', ' ', $post_field->meta_key))); ?> <?php _e('Text', $this->gdpr_personal_data_reports) ?></label></th>
              <td><input type="text" id="<?php echo $this->gdpr_personal_data_reports . "-" . $post_field->meta_key ?>-text" name="<?php echo $this->gdpr_personal_data_reports; ?>[post_meta_fields][<?php echo($post_field->meta_key); ?>][text]" value="<?php if(!empty($field_value_text)) { echo $field_value_text; } else { echo(ucwords(str_replace('_', ' ', $post_field->meta_key))); }?>"/></td>
            </tr>
            <!-- Meta data keys translation -->
          <?php } ?>
          <!-- End check default post meta fields -->
        <?php } ?>
        <!-- End foreach post meta field -->
      </table>
    </div>

    <div id="tab-4" class="gdprpdr_tab-pane">
      <h3><?php _e('GDPR Requests Log', $this->gdpr_personal_data_reports) ?></h3>
      <table class="table table-striped">
        <thead class="thead-light">
          <tr>
            <th scope="col"><?php _e('Request ID', $this->gdpr_personal_data_reports) ?></th>
            <th scope="col"><?php _e('Email', $this->gdpr_personal_data_reports) ?></th>
            <th scope="col"><?php _e('Request Type', $this->gdpr_personal_data_reports) ?></th>
            <th scope="col"><?php _e('Status', $this->gdpr_personal_data_reports) ?></th>
            <th scope="col"><?php _e('HTTP User Agent', $this->gdpr_personal_data_reports) ?></th>
            <th scope="col"><?php _e('Server Addr', $this->gdpr_personal_data_reports) ?></th>
            <th scope="col"><?php _e('Remote Addr', $this->gdpr_personal_data_reports) ?></th>
            <th scope="col"><?php _e('Code', $this->gdpr_personal_data_reports) ?></th>
            <th scope="col"><?php _e('Request Time', $this->gdpr_personal_data_reports) ?></th>
          </tr>
        </thead>
        <tbody>
        <?php foreach($gdpr_requests as $gdpr_request) { ?>
          <tr>
            <td><?php echo $gdpr_request->request_id; ?></td>
            <td><?php echo $gdpr_request->email; ?></td>
            <td><?php echo $this->gdpr_request_types[$gdpr_request->request_type]; ?></td>
            <td><?php echo $this->gdpr_request_statuses[$gdpr_request->status]; ?></td>
            <td><?php echo $gdpr_request->http_user_agent; ?></td>
            <td><?php echo $gdpr_request->server_addr; ?></td>
            <td><?php echo $gdpr_request->remote_addr; ?></td>
            <td><?php echo $gdpr_request->code; ?></td>
            <td><?php echo $gdpr_request->request_time; ?></td>
          </tr>
        <?php } ?>
        </tbody>

      </table>
    </div>

    <?php submit_button('Save settings', 'primary', 'submit', TRUE); ?>
  </form>

  </div>

</div>
