<?php

/**
 * Fired during plugin activation
 *
 * @link       https://gdprdemo.willowdigital.com/
 * @since      1.0.0
 *
 * @package    Gdpr_Personal_Data_Reports
 * @subpackage Gdpr_Personal_Data_Reports/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Gdpr_Personal_Data_Reports
 * @subpackage Gdpr_Personal_Data_Reports/includes
 * @author     Your Name <email@example.com>
 */
class Gdpr_Personal_Data_Reports_Activator {

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.0.0
	 */
	public static function activate() {

		add_action( 'admin_menu', add_menu_page('GDPR Request', 'GDPR Request', 'read', 'gdpr-request') );

		global $wpdb;
		$charset_collate = $wpdb->get_charset_collate();
		$table_name = $wpdb->prefix . 'gdpr_requests';

		$sql = "CREATE TABLE IF NOT EXISTS $table_name (
			`request_id` int(11) NOT NULL AUTO_INCREMENT,
			`email` varchar(255) NOT NULL,
			`status` tinyint(1) NOT NULL,
			`request_type` tinyint(1) NOT NULL,
			`confirmation_attempts` int(1) DEFAULT 0,
			`http_user_agent` text,
			`http_accept_language` text,
			`server_addr` varchar(255),
			`remote_addr` varchar(255),
			`code` varchar(255),
			`confirmation_string` varchar(50),
			`timestamp` int(11),
			`request_time` datetime,
			UNIQUE KEY id (`request_id`)
		) $charset_collate;";

		require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
		dbDelta( $sql );

	}

	/**
	* Returns all unique meta key from user meta database
	*
	* @param no parameter right now
	* @retun std Class
	* @todo do what you do for each meta key.
	*/
	public function get_user_meta_key()
	{
		global $wpdb;
		$select = "SELECT distinct meta_key FROM " . $wpdb->usermeta;
		$usermeta = $wpdb->get_results($select);

		return $usermeta;
	}

	public static function register_newpage() {

	}

}
