<?php

/**
 * The file that defines the core plugin class
 *
 * A class definition that includes attributes and functions used across both the
 * public-facing side of the site and the admin area.
 *
 * @link       https://gdprdemo.willowdigital.com/
 * @since      1.0.0
 *
 * @package    Gdpr_Personal_Data_Reports
 * @subpackage Gdpr_Personal_Data_Reports/includes
 */

/**
 * The core plugin class.
 *
 * This is used to define internationalization, admin-specific hooks, and
 * public-facing site hooks.
 *
 * Also maintains the unique identifier of this plugin as well as the current
 * version of the plugin.
 *
 * @since      1.0.0
 * @package    Gdpr_Personal_Data_Reports
 * @subpackage Gdpr_Personal_Data_Reports/includes
 * @author     Your Name <email@example.com>
 */
class Gdpr_Personal_Data_Reports {

	/**
	 * The loader that's responsible for maintaining and registering all hooks that power
	 * the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      Gdpr_Personal_Data_Reports_Loader    $loader    Maintains and registers all hooks for the plugin.
	 */
	protected $loader;

	/**
	 * The unique identifier of this plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $gdpr_personal_data_reports    The string used to uniquely identify this plugin.
	 */
	protected $gdpr_personal_data_reports;

	/**
	 * The current version of the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $version    The current version of the plugin.
	 */
	protected $version;

	/**
	 * Define the core functionality of the plugin.
	 *
	 * Set the plugin name and the plugin version that can be used throughout the plugin.
	 * Load the dependencies, define the locale, and set the hooks for the admin area and
	 * the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function __construct() {
		if ( defined( 'GDPR_PERSONAL_DATA_REPORTS_VERSION' ) ) {
			$this->version = GDPR_PERSONAL_DATA_REPORTS_VERSION;
		} else {
			$this->version = '1.0.0';
		}
		$this->gdpr_personal_data_reports = 'gdpr-personal-data-reports';

		$this->load_dependencies();
		$this->set_locale();
		$this->define_admin_hooks();
		$this->define_public_hooks();

	}

	/**
	 * Load the required dependencies for this plugin.
	 *
	 * Include the following files that make up the plugin:
	 *
	 * - Gdpr_Personal_Data_Reports_Loader. Orchestrates the hooks of the plugin.
	 * - Gdpr_Personal_Data_Reports_i18n. Defines internationalization functionality.
	 * - Gdpr_Personal_Data_Reports_Admin. Defines all hooks for the admin area.
	 * - Gdpr_Personal_Data_Reports_Public. Defines all hooks for the public side of the site.
	 *
	 * Create an instance of the loader which will be used to register the hooks
	 * with WordPress.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function load_dependencies() {

		/**
		 * The class responsible for orchestrating the actions and filters of the
		 * core plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-gdpr-personal-data-reports-loader.php';

		/**
		 * The class responsible for defining internationalization functionality
		 * of the plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-gdpr-personal-data-reports-i18n.php';

		/**
		 * The class responsible for defining all actions that occur in the admin area.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-gdpr-personal-data-reports-admin.php';

		/**
		 * The class responsible for defining all actions that occur in the public-facing
		 * side of the site.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/class-gdpr-personal-data-reports-public.php';

		/**
		 * The class responsible for generating the GDPR reports
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-gdpr-personal-data-reports-generator.php';
		/**
		 * The class responsible for email templates
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-gdpr-personal-data-reports-email.php';
		/**
		 * The class responsible for deleting / anonymizing user data
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-gdpr-personal-data-reports-remover.php';

		$this->loader = new Gdpr_Personal_Data_Reports_Loader();

	}

	/**
	 * Define the locale for this plugin for internationalization.
	 *
	 * Uses the Gdpr_Personal_Data_Reports_i18n class in order to set the domain and to register the hook
	 * with WordPress.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function set_locale() {

		$plugin_i18n = new Gdpr_Personal_Data_Reports_i18n();

		$this->loader->add_action( 'plugins_loaded', $plugin_i18n, 'load_plugin_textdomain' );

	}

	/**
	 * Register all of the hooks related to the admin area functionality
	 * of the plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function define_admin_hooks() {

		$plugin_admin = new Gdpr_Personal_Data_Reports_Admin( $this->get_gdpr_personal_data_reports(), $this->get_version() );

		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_styles' );
		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_scripts' );

		// Add menu item
		$this->loader->add_action( 'admin_menu', $plugin_admin, 'add_plugin_admin_menu' );

		// Add Settings link to the plugin
		$plugin_basename = plugin_basename( plugin_dir_path( __DIR__ ) . $this->gdpr_personal_data_reports . '.php');
		$this->loader->add_filter( 'plugin_action_links_' . $plugin_basename, $plugin_admin, 'add_action_links' );

		// Save/Update plugin options
		$this->loader->add_action('admin_init', $plugin_admin, 'options_update');

	}

	/**
	 * Register all of the hooks related to the public-facing functionality
	 * of the plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function define_public_hooks() {

		$plugin_public = new Gdpr_Personal_Data_Reports_Public( $this->get_gdpr_personal_data_reports(), $this->get_version() );

		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_styles' );
		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_scripts' );

		$this->loader->add_action( 'init', $plugin_public, 'gdpr_rewrite' );
		$this->loader->add_action( 'init', $plugin_public, 'gdpr_new_rewrite' );
		$this->loader->add_filter( 'query_vars', $plugin_public, 'gdpr_query_vars' );
		//$this->loader->add_action( 'parse_request', $plugin_public, 'gdpr_parse_request' );
		//$this->loader->add_action( 'init', $plugin_public, 'gdpr_rewrite_external' );

		$this->loader->add_shortcode('gdpr-request-form', $plugin_public, 'get_gdpr_request_form');
		$this->loader->add_shortcode('gdpr-forget-me-request-form', $plugin_public, 'get_gdpr_forget_me_request_form');
	}

	/**
	 * Run the loader to execute all of the hooks with WordPress.
	 *
	 * @since    1.0.0
	 */
	public function run() {
		$this->loader->run();
	}

	/**
	 * The name of the plugin used to uniquely identify it within the context of
	 * WordPress and to define internationalization functionality.
	 *
	 * @since     1.0.0
	 * @return    string    The name of the plugin.
	 */
	public function get_gdpr_personal_data_reports() {
		return $this->gdpr_personal_data_reports;
	}

	/**
	 * The reference to the class that orchestrates the hooks with the plugin.
	 *
	 * @since     1.0.0
	 * @return    Gdpr_Personal_Data_Reports_Loader    Orchestrates the hooks of the plugin.
	 */
	public function get_loader() {
		return $this->loader;
	}

	/**
	 * Retrieve the version number of the plugin.
	 *
	 * @since     1.0.0
	 * @return    string    The version number of the plugin.
	 */
	public function get_version() {
		return $this->version;
	}

}
