<?php

/**
 * The public-facing functionality of the plugin.
 *
 * @link       https://gdprdemo.willowdigital.com/
 * @since      1.0.0
 *
 * @package    Gdpr_Personal_Data_Reports
 * @subpackage Gdpr_Personal_Data_Reports/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Gdpr_Personal_Data_Reports
 * @subpackage Gdpr_Personal_Data_Reports/public
 * @author     Your Name <email@example.com>
 */
class Gdpr_Personal_Data_Reports_Public {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $gdpr_personal_data_reports    The ID of this plugin.
	 */
	private $gdpr_personal_data_reports;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $gdpr_personal_data_reports       The name of the plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $gdpr_personal_data_reports, $version ) {

		$this->gdpr_personal_data_reports = $gdpr_personal_data_reports;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Gdpr_Personal_Data_Reports_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Gdpr_Personal_Data_Reports_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style( $this->gdpr_personal_data_reports, plugin_dir_url( __FILE__ ) . 'css/gdpr-personal-data-reports-public.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Gdpr_Personal_Data_Reports_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Gdpr_Personal_Data_Reports_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_script( $this->gdpr_personal_data_reports, plugin_dir_url( __FILE__ ) . 'js/gdpr-personal-data-reports-public.js', array( 'jquery' ), $this->version, false );

	}

	/**
	 * Rewrite the GDPR Request URL
	 */
	public function gdpr_rewrite()
	{
		//$url = str_replace( trailingslashit( site_url() ), '', plugins_url( 'gdpr-request.php', __FILE__ ) );
		//$url = str_replace( trailingslashit( site_url() ), '', plugins_url( 'class-gdpr-personal-data-reports-public.php', __FILE__ ) );
		//add_rewrite_rule( 'gdpr-request\\.php$', $url, 'top' );
		//add_rewrite_rule( 'gdpr-request$', 'index.php?gdpr_request=1', 'top' );
		//add_rewrite_rule( 'gdpr-forget-me$', 'index.php?forget_me=1', 'top');

	}

	public function gdpr_new_rewrite()
	{
		//add_rewrite_rule( 'gdpr-new$', 'index.php?new_gdpr_request=1', 'top' );
	}

	/**
	 * Custom query variables
	 * @param  [type] $query_vars [description]
	 * @return [type]             [description]
	 */
	public function gdpr_query_vars( $query_vars )
	{
			$query_vars[] = 'gdpr_email';
	    $query_vars[] = 'gdpr_request';
			$query_vars[] = 'confirm_gdpr_request';
			$query_vars[] = 'confirmation_code';
			$query_vars[] = 'new_gdpr_request';
			$query_vars[] = 'forget_me';
			$query_vars[] = 'confirm_forget_me_request';
			$query_vars[] = 'new_forget_me_request';
			$query_vars[] = 'request';
	    return $query_vars;
	}

	function gdpr_parse_request( &$wp )
	{

			if ( array_key_exists( 'gdpr_request', $wp->query_vars ) ) {
	    }

			if ( array_key_exists( 'forget_me', $wp->query_vars ) ) {
			}

			if ( array_key_exists( 'confirm_forget_me_request', $wp->query_vars ) ) {
			}

			if ( array_key_exists( 'new_forget_me_request', $wp->query_vars ) ) {
			}

			if ( array_key_exists( 'new_gdpr_request', $wp->query_vars ) ) {
			}

			if ( array_key_exists( 'confirm_gdpr_request', $wp->query_vars ) ) {
			}

	    return;
	}

	/**
	 * Rewrite the GDPR Request URL
	 */
	public function gdpr_rewrite_external()
	{
			global $wp_rewrite;
			$plugin_url = plugins_url( 'gdpr-request.php', __FILE__ );
			$plugin_url = substr( $plugin_url, strlen( home_url() ) + 1 );

			$wp_rewrite->add_external_rule( 'gdpr-request.php$', $plugin_url );
	}

	/**
	 * Control the GDPR personal data report form
	 * @return [string]
	 */
	public function get_gdpr_request_form($atts)
	{
		$a = shortcode_atts( array(
				'header_classes' => '',
				'text_classes' => '',
				'button_classes' => 'button submit gdprpdr_submit-button',
		), $atts );

		$query_vars = $_GET;
		$url = get_page_link();
		$gdpr_main_class = new Gdpr_Personal_Data_Reports();
		$gdpr_personal_data_reports = $gdpr_main_class ->get_gdpr_personal_data_reports();
		$gdpr = new Gdpr_Personal_Data_Reports_Generator($gdpr_personal_data_reports);
		$name = get_bloginfo('name');

		// New Request
		if(empty($query_vars['new_gdpr_request']) && empty($query_vars['confirm_gdpr_request']))
		{
			return '<div class="gdprpdr_form_wrap"><div><h3 class="' . $a['header_classes'] . '">' . __('GDPR Request', $gdpr_personal_data_reports) . '</h3></div>
			<div class="gdprpdr_entry-content"><p class="' . $a['text_classes'] . '">' . __('To request a GDPR report please submit your email address below. We will email you a confirmation link to verify
			you are the owner of the account.', $gdpr_personal_data_reports) . '</p>
			<form action="' . $url . '?new_gdpr_request=1" method="post">
				<input type="email" name="email" placehoder="' . __('E-mail Address', $gdpr_personal_data_reports) . '" required><br>

				<input type="checkbox" name="gdpr_request_form_checkbox" required>
				<label for="gdpr_request_form_checkbox">' .
				sprintf(__('I consent to having %s collect my email, IP address and browser request details for the purpose of generating the personal data report (to learn more about our privacy policy please visit our privacy policy statement).', $gdpr_personal_data_reports), $name) .
				'</label>

				<input type="submit" class="' . $a['button_classes'] . '" value="' . __('Submit', $gdpr_personal_data_reports) . '">
			</form></div></div>';
		}

		// Submit of the new request
		if(!empty($query_vars['new_gdpr_request']))
		{
			$email = $_POST['email'];
			$validation_errors = $gdpr->validate_email($email);

			// Email failed the validation
			if($validation_errors)
			{
				$errors = '';
				foreach ($validation_errors as $error)
				{
					$errors = '<li class="gdprpdr_error">' . $error . '</li>';
				}

				return '<div class="gdprpdr_form_wrap"><div><h1 class="' . $a['header_classes'] . '">' . __('GDPR Request Failed', $gdpr_personal_data_reports) . '</h1></div>
				<div><p class="' . $a['text_classes'] . '">' . __('There was problem with your GDPR request:', $gdpr_personal_data_reports) . '</p>
				<ul>' . $errors . '</ul>
				<form action="' . $url . '?new_gdpr_request=1" method="post">
					<input type="email" name="email" placehoder="' . __('E-mail Address', $gdpr_personal_data_reports) . '" required><br>

					<input type="checkbox" name="gdpr_request_form_checkbox" required>
					<label for="gdpr_request_form_checkbox">' .
					sprintf(__('I consent to having %s collect my email, IP address and browser request details for the purpose of generating the personal data report (to learn more about our privacy policy please visit our privacy policy statement).', $gdpr_personal_data_reports), $name) .
					'</label>

					<input type="submit" class="' . $a['button_classes'] . '" value="' . __('Submit', $gdpr_personal_data_reports) . '">
				</form></div></div>';
			}
			// Email validated, request can proceed
			else
			{
				$gdpr->create_new_request($email, $_SERVER, 1, $url);

				return '<div class="gdprpdr_notification_wrap"><div><h3 class="' . $a['header_classes'] . '">' . __('Your GDPR request has been submitted.', $gdpr_personal_data_reports) . '</h3></h1><div><p class="' . $a['text_classes'] . '">' . sprintf(__('We have emailed a confirmation link to your email address: %s. Please click it to verify your ownership of the account and proceed.', $gdpr_personal_data_reports), $email) . '</p></div></div>';
			}
		}

		// Confirmation attempt
		if(!empty($query_vars['confirm_gdpr_request']))
		{
			$confirmed = false;
			$processed = 0;

			// Check GDPR status, if already processed, ignore confirmation.
			$processed = $gdpr->get_gdpr_request_status($query_vars);
			// Check confirmation attempt is permitted.
			$confirmation_allowed = $gdpr->is_allowed_confirmation_attempt($query_vars['request']);

			if($processed || !$confirmation_allowed)
			{
				if(!$confirmation_allowed)
				{
					return '<div class="gdprpdr_notification_wrap"><p class="gdprpdr_error "' . $a['text_classes'] . '">' . __('You have exceeded the number of allowed confirmation attempts. Please try creating a new request.', $gdpr_personal_data_reports) . '</p></div>';
				}
				return '<div class="gdprpdr_notification_wrap"><p class="gdprpdr_error "' . $a['text_classes'] . '">' . __('Your GDPR request has already been confirmed and email to you.<br>If you need your data re-sent to you please create a new request.', $gdpr_personal_data_reports) . '</p></div>';
			}
			else
			{
				$confirmed = $gdpr->verify_gdpr_request($query_vars);
			}

			if($confirmed && !$processed)
			{
				// Update GDPR request status to confirmed
				$gdpr->update_gdpr_request_status($query_vars['request'], $gdpr->status_confirmed);
				// Generate personal data report
				$data_report = $gdpr->generate_personal_data_report($query_vars['request']);
				// Build the template
				$template = new Gdpr_Personal_Data_Reports_Email();
				$gdpr_report_template = $template->get_report_body($data_report);
				// Email the report
				$gdpr->email_personal_data_report($gdpr_report_template, $confirmed);
				// Update GDPR request status to emailed
				$gdpr->update_gdpr_request_status($query_vars['request'], $gdpr->status_emailed);

				return '<div class="gdprpdr_notification_wrap"><p class="' . $a['text_classes'] . '">' . __('Your request has been confirmed.<br>We will email you your personal data report shortly.', $gdpr_personal_data_reports) . '</p></div>';
			}

			if(!$confirmed && !$processed)
			{
				return '<div class="gdprpdr_notification_wrap"><p class="gdprpdr_error ' . $a['text_classes'] . '">' . __('We could not confirm your GDPR request.<br>Please make sure you are using a complete confirmation link.', $gdpr_personal_data_reports) . '</p></div>';
			}
		}

	}

	/**
	 * Control the GDPR forget me form
	 * @return [string]
	 */
	public function get_gdpr_forget_me_request_form($atts)
	{
		$a = shortcode_atts( array(
				'header_classes' => '',
				'text_classes' => '',
				'button_classes' => 'button submit gdprpdr_submit-button',
		), $atts );

		$query_vars = $_GET;
		$url = get_page_link();
		$gdpr_main_class = new Gdpr_Personal_Data_Reports();
		$gdpr_personal_data_reports = $gdpr_main_class ->get_gdpr_personal_data_reports();
		$gdpr = new Gdpr_Personal_Data_Reports_Generator($gdpr_personal_data_reports);
		$remover = new Gdpr_Personal_Data_Reports_Remover($gdpr_personal_data_reports);
		$options = get_option($this->gdpr_personal_data_reports);
		$name = get_bloginfo('name');

		// Removal requests are not allowed
		if(!$options['right_to_be_forgotten'])
		{
		  return '<div>
		  <p class="' . $a['text_classes'] . '">' . __('"Right to be Forgotten" form is not enabled on this site.', $this->gdpr_personal_data_reports) . '</p></div>';
		}

		// New Removal Request
		if(empty($query_vars['new_forget_me_request']) && empty($query_vars['confirm_forget_me_request']))
		{
		  return '<div class="gdprpdr_form_wrap"><div><h3 class="' . $a['header_classes'] . '">' . __('GDPR Account Deletion Request', $this->gdpr_personal_data_reports) . '</h3></div>
		  <div><p class="' . $a['text_classes'] . '">' . __('To request your account deleted from our system please enter your email address below. We will email you a confirmation link to verify
		  you are the owner of the account.', $this->gdpr_personal_data_reports) . '</p>
		  <form action="' . $url . '?new_forget_me_request=1" method="post">
		    <input type="email" name="email" placehoder="' . __('E-mail Address', $this->gdpr_personal_data_reports) . '" required><br>

				<input type="checkbox" name="gdpr_forget_me_form_checkbox" required>
				<label for="gdpr_forget_me_form_checkbox">' .
				sprintf(__('I consent to having %s collect my email, IP address and browser request details for the purpose of processing an account deletion request (to learn more about our privacy policy please visit our privacy policy statement).', $gdpr_personal_data_reports), $name) .
				'</label>

				<input type="submit" class="' . $a['button_classes'] . '" value="' . __('Submit', $this->gdpr_personal_data_reports) . '">
		  </form></div></div>';
		}

		// Submit of the new request
		if(!empty($query_vars['new_forget_me_request']))
		{
		  $email = $_POST['email'];
		  $validation_errors = $gdpr->validate_email($email);

		  // Email failed the validation
		  if($validation_errors)
		  {
		    $errors = '';
		    foreach ($validation_errors as $error)
		    {
		      $errors = '<li class="gdprpdr_error">' . $error . '</li>';
		    }

		    return '<div class="gdprpdr_form_wrap"><h3 class="' . $a['header_classes'] . '">' . __('GDPR Account Deletion Request Failed', $this->gdpr_personal_data_reports) . '</h3></div>
		    <div><p class="' . $a['text_classes'] . '">' . __('There was problem with your GDPR request:', $this->gdpr_personal_data_reports) . '</p>
		    <ul>' . $errors . '</ul>
		    <form action="' . $url . '?new_gdpr_request=1" method="post">
		      <input type="email" name="email" placehoder="' . __('E-mail Address', $this->gdpr_personal_data_reports) . '" required><br>

					<input type="checkbox" name="gdpr_forget_me_form_checkbox" required>
					<label for="gdpr_forget_me_form_checkbox"><small>' .
					sprintf(__('I consent to having %s collect my email, IP address and browser request details for the purpose of processing an account deletion request (to learn more about our privacy policy please visit our privacy policy statement).', $gdpr_personal_data_reports), $name) .
					'</small></label>

					<input type="submit" class="' . $a['button_classes'] . '" value="' . __('Submit', $this->gdpr_personal_data_reports) . '">
		    </form></div>';
		  }
		  // Email validated, request can proceed
		  else
		  {
		    $gdpr->create_new_request($email, $_SERVER, 2, $url);

		    return '<div class="gdprpdr_notification_wrap"><h1 class="' . $a['header_classes'] . '">' . __('Your account deletion request has been submitted.', $this->gdpr_personal_data_reports) . '</h1></div><div><p class="' . $a['text_classes'] . '">' . sprintf(__('We have emailed a confirmation link to your email address: %s. Please click it to verify your ownership of the account and proceed.', $this->gdpr_personal_data_reports), $email) . '</p><p class="' . $a['text_classes'] . '"><strong>' . __('IMPORTANT! Clicking the confirmation link will result in your account data being anonymized and deleted. This means you will no longer be able to login to your account and access your account information like order history. This operation CAN NOT BE REVERSED!', $this->gdpr_personal_data_reports) . '</strong></p></div>';
		  }

		}

		// Confirmation attempt
		if(!empty($query_vars['confirm_forget_me_request']))
		{
		  $confirmed = false;
		  $processed = 0;

		  // Check GDPR status, if already processed, ignore confirmation.
		  $processed = $gdpr->get_gdpr_request_status($query_vars);
			// Check confirmation attempt is permitted.
			$confirmation_allowed = $gdpr->is_allowed_confirmation_attempt($query_vars['request']);

		  if($processed || !$confirmation_allowed)
		  {
				if(!$confirmation_allowed)
				{
					return '<div class="gdprpdr_notification_wrap"><p class="gdprpdr_error "' . $a['text_classes'] . '">' . __('You have exceeded the number of allowed confirmation attempts. Please try creating a new request.', $gdpr_personal_data_reports) . '</p></div>';
				}
		    return '<div class="gdprpdr_notification_wrap"><p class="gdprpdr_error' . $a['text_classes'] . '">' . __('Your account deletion request has already been confirmed and processed.', $this->gdpr_personal_data_reports) . '</p></div>';
		  }
		  else
		  {
		    $confirmed = $gdpr->verify_gdpr_request($query_vars);
		  }

		  if($confirmed && !$processed)
		  {
		    // Update GDPR request status to confirmed
		    $gdpr->update_gdpr_request_status($query_vars['request'], $gdpr->status_confirmed);

		    $email = $gdpr->get_request_email($query_vars['request']);
		    $user = get_user_by( 'email', $email );
		    $user_id = $user->ID;
		    // Anonymize all user data
		    $remover->anonymize_user_data($user_id);

		    // Delete user metadata
		    $remover->delete_user_metadata($user_id);

		    // Delete GDPR requests (except for deletion request)
		    $remover->delete_gdpr_requests($email);

		    // Update GDPR request status to completed
		    $gdpr->update_gdpr_request_status($query_vars['request'], $gdpr->status_completed);

		    return '<div class="gdprpdr_notification_wrap"><p class="' . $a['text_classes'] . '">' . __('Your ACCOUNT DELETION request has been confirmed.<br>We will delete your account and personal data shortly.', $this->gdpr_personal_data_reports) . '</p></div>';
		  }

		  if(!$confirmed && !$processed)
		  {
		    return '<div class="gdprpdr_notification_wrap"><p class="gdprpdr_error ' . $a['text_classes'] . '">' . __('We could not confirm your ACCOUNT DELETION request.<br>Please make sure you are using a complete confirmation link.', $this->gdpr_personal_data_reports) . '</p></div>';
		  }
		}
	}

}
