<?php
/**
 * Full Width CTA Block Template.
 *
 * @param   array $block The block settings and attributes.
 * @param   string $content The block inner HTML (empty).
 * @param   bool $is_preview True during AJAX preview.
 * @param   (int|string) $post_id The post ID this block is saved to.
 */

// Create id attribute allowing for custom "anchor" value.
$id = 'full-width-cta-' . $block['id'];
if( !empty($block['anchor']) ) {
    $id = $block['anchor'];
}

// Create class attribute allowing for custom "className" and "align" values.
$className = 'full-width-cta';
if( !empty($block['className']) ) {
    $className .= ' ' . $block['className'];
}
if( !empty($block['align']) ) {
    $className .= ' align' . $block['align'];
}

if (get_field('full_cta_block_background_color')) {
    //$full_cta_block_background_color = get_field('full_cta_block_background_color');
    $full_cta_block_background_transparency = get_field('full_cta_block_background_transparency');
    $full_cta_transp = $full_cta_block_background_transparency * 0.01;
    
        $Hex_color = get_field('full_cta_block_background_color');
        $RGB_color = hex2rgbwed_events($Hex_color);
        $Final_Rgb_color = implode(", ", $RGB_color);
    
}

if (get_field('full_cta_block_background_image')) {
    $full_cta_block_background_image = get_field('full_cta_block_background_image');
    ?>
        <div id="<?php echo esc_attr($id); ?>" class="<?php echo esc_attr($className); ?>" style="background-image: url(<?php echo $full_cta_block_background_image; ?>)"><div class="overlay" style="background-color: rgba(<?php echo $Final_Rgb_color; ?>,<?php echo $full_cta_transp;?>)"><div class="wrap">
    <?php
} else {
    ?>
        <div id="<?php echo esc_attr($id); ?>" class="<?php echo esc_attr($className); ?>"><div class="overlay" style="background-color: rgba(<?php echo $Final_Rgb_color; ?>,<?php echo $full_cta_transp;?>)"><div class="wrap">
<?php
}


    
if (get_field('full_cta_block_heading')) {
    $full_cta_block_heading = get_field('full_cta_block_heading');
    echo '<h2>' . $full_cta_block_heading . '</h2>';
} 
    
if (get_field('full_cta_block_content')) {
    $full_cta_block_content = get_field('full_cta_block_content');
    echo $full_cta_block_content;
} 
    
if (get_field('full_cta_block_button_link')) {
    $full_cta_block_button_link = get_field('full_cta_block_button_link');
    if (get_field('full_cta_block_button_text_color')) {
        $full_cta_block_button_text_color = get_field('full_cta_block_button_text_color');
    }
    $button_link = $full_cta_block_button_link['url'];
    $button_target = $full_cta_block_button_link['target'] ? $full_cta_block_button_link['target'] : '_self';
    $full_cta_block_button_text = get_field('full_cta_block_button_text');
    echo '<p class="full-width-cta-btn"><a href="' . $button_link . '" target="' . $button_target  . '"><button style="color: ' . $full_cta_block_button_text_color . '">' . $full_cta_block_button_text . '</button></a></p>';
}

if (get_field('full_cta_block_height')) {
    $full_cta_block_height = get_field('full_cta_block_height');
    
?>
<style type="text/css">

    .full-width-cta,
    .full-width-cta .overlay,
    .full-width-cta .wrap {
        min-height: <?php echo $full_cta_block_height; ?>px;
    }
    
</style>
<?php
    
}
    
echo '</div></div></div>';