<?php
/**
 * Related Post Block Template.
 *
 * @param   array $block The block settings and attributes.
 * @param   string $content The block inner HTML (empty).
 * @param   bool $is_preview True during AJAX preview.
 * @param   (int|string) $post_id The post ID this block is saved to.
 */

// Create id attribute allowing for custom "anchor" value.
$id = 'bw-related-posts-' . $block['id'];
if( !empty($block['anchor']) ) {
    $id = $block['anchor'];
}

// Create class attribute allowing for custom "className" and "align" values.
$className = 'bw-related-posts';
if( !empty($block['className']) ) {
    $className .= ' ' . $block['className'];
}
if( !empty($block['align']) ) {
    $className .= ' align' . $block['align'];
}

?>
<div id="<?php echo esc_attr($id); ?>" class="<?php echo esc_attr($className); ?>">
<?php
    
$block_posts_to_display = get_field('block_posts_to_display');
    
$args = array(
		'post_type' => 'post',
		'paged' => get_query_var( 'paged' ),
        'posts_per_page' => $block_posts_to_display,
	);
	
	global $wp_query;
	$wp_query = new WP_Query( $args );
	if( $wp_query->have_posts() ): 
		while( $wp_query->have_posts() ): $wp_query->the_post(); global $post;
			$classes = 'one-third';
			if( 0 == $wp_query->current_post )
				$classes .= ' first-post';
            if( 1 == $wp_query->current_post )
                $classes .= ' second-post';
            if( 2 == $wp_query->current_post )
                $classes .= ' third-post';
            if( 3 == $wp_query->current_post )
                $classes .= ' fourth-post';

            $featured_image = get_the_post_thumbnail_url( $post->ID, 'large' );
            echo '<div class="blog-archive-post '.  $classes . '" style="background-image: url(' . $featured_image . ')">';
        
                //echo get_the_post_thumbnail( $post->ID, 'large' );
                echo '<div class="blog-archive-post-info">';
                $categories = get_the_category();
                if ( ! empty( $categories ) ) {
                    echo '<p class="latest-posts-cat"><a href="' . esc_url( get_category_link( $categories[0]->term_id ) ) . '">' . esc_html( $categories[0]->name ) . '</a></p>';
                } 
                echo '<h2><a href="' . get_permalink() . '">' . get_the_title() . '</a></h2>';	
                echo '<p class="latest-posts-date">' . get_the_date() . '</p>';
                echo '</div>';
            echo '</div>';

		endwhile;
		genesis_posts_nav();
	endif;
	wp_reset_query();
    
echo '</div>';