<?php
/**
 * FAQ Block Template.
 *
 * @param   array $block The block settings and attributes.
 * @param   string $content The block inner HTML (empty).
 * @param   bool $is_preview True during AJAX preview.
 * @param   (int|string) $post_id The post ID this block is saved to.
 */

// Create id attribute allowing for custom "anchor" value.
$id = 'faq-block-' . $block['id'];
if( !empty($block['anchor']) ) {
    $id = $block['anchor'];
}

// Create class attribute allowing for custom "className" and "align" values.
$className = 'faq-block';
if( !empty($block['className']) ) {
    $className .= ' ' . $block['className'];
}
if( !empty($block['align']) ) {
    $className .= ' align' . $block['align'];
}

?>
<div id="<?php echo esc_attr($id); ?>" class="<?php echo esc_attr($className); ?>">
<?php
    
 if( have_rows('faq_block') ): ?>
				<div id="accordion" role="tablist">
					<?php $i=1; while ( have_rows('faq_block') ) : the_row(); ?>
						<div class="card">
						    <div class="card-header" role="tab" id="heading-<?php echo $i; ?>">
						      <h3 class="faq-term">
						          
						       <?php if($i==1) { ?>
						       
						       <a data-toggle="collapse" href="#collapse-<?php echo $i; ?>" aria-expanded="true" aria-controls="collapseOne">
						           
						      <?php } else { ?>
						          
						        <a data-toggle="collapse" href="#collapse-<?php echo $i; ?>" aria-expanded="false" aria-controls="collapseOne">
						            
						      <?php } ?>
						         <?php the_sub_field('faq_question'); ?>
						        </a>
						      </h3>
						    </div>
						    <div id="collapse-<?php echo $i; ?>" class="collapse <?php if ($i==1) { echo 'show'; } ?>" role="tabpanel" data-parent="#accordion" aria-labelledby="heading-<?php echo $i; ?>">
						      <div class="card-body">
						       	<?php the_sub_field('faq_answer'); ?>
						      </div>
						    </div>
						</div>
					<?php $i++; endwhile; ?>
                    
				</div>
			<?php endif;

echo '</div>';