<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://gdprdemo.willowdigital.com/
 * @since      1.0.0
 *
 * @package    Gdpr_Personal_Data_Reports
 * @subpackage Gdpr_Personal_Data_Reports/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Gdpr_Personal_Data_Reports
 * @subpackage Gdpr_Personal_Data_Reports/admin
 * @author     Your Name <email@example.com>
 */
class Gdpr_Personal_Data_Reports_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $gdpr_personal_data_reports    The ID of this plugin.
	 */
	private $gdpr_personal_data_reports;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $gdpr_personal_data_reports       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $gdpr_personal_data_reports, $version ) {

		$this->gdpr_personal_data_reports = $gdpr_personal_data_reports;

		// Default WordPress usermeta fields
		$this->wp_usermeta = array(
				'nickname',
				'first_name',
				'last_name',
				'description',
				'rich_editing',
				'syntax_highlighting',
				'comment_shortcuts',
				'admin_color',
				'use_ssl',
				'show_admin_bar_front',
				'locale',
				'wp_capabilities',
				'wp_user_level',
				'dismissed_wp_pointers',
				'show_welcome_panel',
				'session_tokens',
				'wp_dashboard_quick_press_last_post_id',
				'community-events-location',
				//'blueberry_count'
		);

		// Default WordPress postmeta fields
		$this->wp_postmeta = array(
				'_wp_page_template',
				//'strawberry_count',
		);

		$this->gdpr_request_statuses = array(
			'0' => __('Pending', $this->gdpr_personal_data_reports),
			'1' => __('Confirmed', $this->gdpr_personal_data_reports),
			'2' => __('Emailed', $this->gdpr_personal_data_reports),
			'3' => __('Account Deleted', $this->gdpr_personal_data_reports),
		);

		$this->gdpr_request_types = array(
			'1' => __('Report', $this->gdpr_personal_data_reports),
			'2' => __('Forget Me', $this->gdpr_personal_data_reports),
		);

		$this->version = $version;

		$this->post_meta_fields = $this->get_post_meta_key();
		$this->user_meta_fields = $this->get_user_meta_key();
	}

	/**
	 * Register the administration menu for this plugin into the WordPress Dashboard menu.
	 * @since 1.0.0
	 */
	public function add_plugin_admin_menu() {
		add_options_page(__('GDPR Personal Data Reports Configuration', $this->gdpr_personal_data_reports), __('GDPR Settings', $this->gdpr_personal_data_reports), 'manage_options', $this->gdpr_personal_data_reports, array($this, 'display_plugin_setup_page'));
	}

	/**
	 * Add settings action link to the plugins page.
	 * @since 1.0.0
	 */
	public function add_action_links( $links ) {
		/*
		*  Documentation : https://codex.wordpress.org/Plugin_API/Filter_Reference/plugin_action_links
		*/
		$settings_link = array(
			'<a href="' . admin_url( 'options-general.php?page=' . $this->gdpr_personal_data_reports ) . '">' . __('Settings', $this->gdpr_personal_data_reports) . '</a>',
		);

		return array_merge( $settings_link, $links);
	}

	/**
	 * Render the settings page for this plugin.
	 * @since 1.0.0
	 */
	public function display_plugin_setup_page() {
		include_once( 'partials/gdpr-personal-data-reports-admin-display.php' );
	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Gdpr_Personal_Data_Reports_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Gdpr_Personal_Data_Reports_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style( $this->gdpr_personal_data_reports, plugin_dir_url( __FILE__ ) . 'css/gdpr-personal-data-reports-admin.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Gdpr_Personal_Data_Reports_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Gdpr_Personal_Data_Reports_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_script( $this->gdpr_personal_data_reports, plugin_dir_url( __FILE__ ) . 'js/gdpr-personal-data-reports-admin.js', array( 'jquery' ), $this->version, false );

	}

	/**
	 * Get all GDPR requests
	 * @return [array]
	 */
	public function get_gdpr_requests()
	{
		global $wpdb;

		$limit = 100;
		$options = get_option($this->gdpr_personal_data_reports);
		if(!empty($options['max_requests_log']))
		{
			$limit = $options['max_requests_log'];
		}

		$select = "SELECT * FROM " . $wpdb->prefix . "gdpr_requests" . " LIMIT " . $limit;
		$gdpr_requests = $wpdb->get_results($select);

		return $gdpr_requests;
	}

	/**
	* Returns all unique meta key from post meta database
	*
	* @param no parameter right now
	* @retun std Class
	*/
	public function get_post_meta_key()
	{
		global $wpdb;
		$select = "SELECT distinct meta_key FROM " . $wpdb->postmeta;
		$postmeta = $wpdb->get_results($select);

		return $postmeta;
	}

	/**
	* Returns all unique meta key from user meta database
	*
	* @param no parameter right now
	* @retun std Class
	*/
	public function get_user_meta_key()
	{
		global $wpdb;
		$select = "SELECT distinct meta_key FROM " . $wpdb->usermeta;
		$usermeta = $wpdb->get_results($select);

		return $usermeta;
	}

	/**
	 * Update GDPR Options
	 * @return
	 */
	public function options_update() {

		register_setting($this->gdpr_personal_data_reports, $this->gdpr_personal_data_reports, array($this, 'sanitize'));
	}

	/**
	 * Validate GDPR Settings
	 * @param  array
	 * @return array
	 */
	public function sanitize( $input ) {
		$sanitized = array();

		$sanitized['other_locations'] = $input['other_locations'];
		$sanitized['physical_locations'] = $input['physical_locations'];
		$sanitized['max_requests'] = $input['max_requests'];
		// Cap the requests log to 1000 to prevent crashes
		$sanitized['max_requests_log'] = (int)$input['max_requests_log'] < 1000 ? $input['max_requests_log'] : 1000;
		$sanitized['max_confirmation_attempts'] = (int)$input['max_confirmation_attempts'] < 10 ? $input['max_confirmation_attempts'] : 10;
		$sanitized['header'] = $input['header'];
		$sanitized['footer'] = $input['footer'];
		$sanitized['user_meta_fields'] = $input['user_meta_fields'];
		$sanitized['post_meta_fields'] = $input['post_meta_fields'];
		$sanitized['right_to_be_forgotten'] = $input['right_to_be_forgotten'];

		return $sanitized;

	}

}
