<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://gdprdemo.willowdigital.com/
 * @since             1.0.0
 * @package           gdpr_personal_data_reports
 *
 * @wordpress-plugin
 * Plugin Name:       GDPR Personal Data Reports
 * Plugin URI:        http://example.com/gdpr-personal-data-reports-uri/
 * Description:       Provides your customers an automated process of requesting and retrieving their personal data in line with The General Data Protection Regulation.
 * Regulation.
 * Version:           1.0.5
 * Author:            Willows Consulting Ltd.
 * Author URI:        https://www.willows-consulting.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       gdpr-personal-data-reports
 * Domain Path:       /languages
 * Requires at least: 4.4
 * Tested up to: 4.9
 *
 * @author Wojtek Murawski <wojtek@willowsconsulting.ie>
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'gdpr_personal_data_reports_VERSION', '1.0.4' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-gdpr-personal-data-reports-activator.php
 */
function activate_gdpr_personal_data_reports() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-gdpr-personal-data-reports-activator.php';
	Gdpr_Personal_Data_Reports_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-gdpr-personal-data-reports-deactivator.php
 */
function deactivate_gdpr_personal_data_reports() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-gdpr-personal-data-reports-deactivator.php';
	Gdpr_Personal_Data_Reports_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_gdpr_personal_data_reports' );
register_deactivation_hook( __FILE__, 'deactivate_gdpr_personal_data_reports' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-gdpr-personal-data-reports.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_gdpr_personal_data_reports() {

	$plugin = new Gdpr_Personal_Data_Reports();
	$plugin->run();
	//$plugin->custom_post_type();

}
run_gdpr_personal_data_reports();
