<?php

/**
 * The file that defines all email templates
 *
 * A class definition that includes functions for generating email templates
 * used in the GDPR request flow
 *
 * @link       https://gdprdemo.willowdigital.com/
 * @since      1.0.0
 *
 * @package    Gdpr_Personal_Data_Reports
 * @subpackage Gdpr_Personal_Data_Reports/includes
 */

class Gdpr_Personal_Data_Reports_Email {
 public $header;
 public $footer;
 public $gdpr_personal_data_reports;

 public function __construct()
 {
   $this->header = $this->get_header();
   $this->footer = $this->get_footer();
   $this->gdpr_personal_data_reports = 'gdpr-personal-data-reports';
 }

 /**
  * Get content of the confirmation email
  * @param  [array] $texts texts and links to be included in the email
  * @return [string] pregenerated content of the confirmation email
  */
 public function get_confirmation_body($texts)
 {
  $html = '';
  $html .= $this->header;

  ob_start();
  require_once( plugin_dir_path( dirname( __FILE__ )) . 'includes/mail/gdpr_confirmation.php' );
  $html  .= ob_get_contents();
  ob_end_clean();

  $html .= $this->footer;

  return $html;

 }

 /**
  * Get content of the confirmation email
  * @param  [array] $texts texts and links to be included in the email
  * @return [string] pregenerated content of the confirmation email
  */
 public function get_delete_confirmation_body($texts)
 {
   $html = '';

   $html .= $this->header;

   ob_start();
   require_once( plugin_dir_path( dirname( __FILE__ )) . 'includes/mail/gdpr_delete_confirmation.php' );
   $html  .= ob_get_contents();
   ob_end_clean();

   $html .= $this->footer;

   return $html;

 }

 /**
  * Get body of the GDPR report email
  * @param  [array] $data
  * @return [string]
  */
 public function get_report_body($data)
 {
   /**'ID' => $user->ID,
   'email' => $email,
   'comments' => $comments,
   'user_data' => $user_data,
   'user_meta' => $user_meta,
   'settings' => $settings,
   'gdpr_requests' => $gdpr_requests,
   'gdpr_requests_statuses' => $gdpr_request_statuses,
   'gdpr_requests_types' => $gdpr_request_types,
   'empty_record' => '---',
    * );
    */

   ob_start();
   require_once( plugin_dir_path( dirname( __FILE__ )) . 'includes/mail/gdpr_report.php' );
   $html  = ob_get_contents();
   ob_end_clean();

   return $html;
 }

 /**
  * Get email header including css
  * @return [string]
  */
 public function get_header()
 {

   ob_start();
   require_once( plugin_dir_path( dirname( __FILE__ )) . 'includes/mail/gdpr_header.php' );
   $html  = ob_get_contents();
   ob_end_clean();

   return $html;
 }

 /**
  * Get email footer
  * @return [string]
  */
 public function get_footer()
 {
   $html = '';

   return $html;
 }

 /**
  * Get content of the GDPR raport email
  * @param  [array] $data texts and report data to be included in the report
  * @return [string] pregenerated content of the raport email
  */
 public function get_template($data)
 {
   return $this->get_header() . ' ' . $this->get_report_body($data) . ' ' . $this->get_footer();
 }

}
