<?php
/**
 * Genesis Sample.
 *
 * This file adds functions to the Genesis Sample Theme.
 *
 * @package Genesis Sample
 * @author  StudioPress
 * @license GPL-2.0-or-later
 * @link    https://www.studiopress.com/
 */

// Starts the engine.
require_once get_template_directory() . '/lib/init.php';

// Sets up the Theme.
require_once get_stylesheet_directory() . '/lib/theme-defaults.php';

add_action( 'after_setup_theme', 'genesis_sample_localization_setup' );
/**
 * Sets localization (do not remove).
 *
 * @since 1.0.0
 */
function genesis_sample_localization_setup() {

	load_child_theme_textdomain( genesis_get_theme_handle(), get_stylesheet_directory() . '/languages' );

}

// Adds helper functions.
require_once get_stylesheet_directory() . '/lib/helper-functions.php';

// Adds image upload and color select to Customizer.
require_once get_stylesheet_directory() . '/lib/customize.php';

// Includes Customizer CSS.
require_once get_stylesheet_directory() . '/lib/output.php';

// Adds WooCommerce support.
require_once get_stylesheet_directory() . '/lib/woocommerce/woocommerce-setup.php';

// Adds the required WooCommerce styles and Customizer CSS.
require_once get_stylesheet_directory() . '/lib/woocommerce/woocommerce-output.php';

// Adds the Genesis Connect WooCommerce notice.
require_once get_stylesheet_directory() . '/lib/woocommerce/woocommerce-notice.php';

add_action( 'after_setup_theme', 'genesis_child_gutenberg_support' );
/**
 * Adds Gutenberg opt-in features and styling.
 *
 * @since 2.7.0
 */
function genesis_child_gutenberg_support() { // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedFunctionFound -- using same in all child themes to allow action to be unhooked.
	require_once get_stylesheet_directory() . '/lib/gutenberg/init.php';
}

// Registers the responsive menus.
if ( function_exists( 'genesis_register_responsive_menus' ) ) {
	genesis_register_responsive_menus( genesis_get_config( 'responsive-menus' ) );
}

add_action( 'wp_enqueue_scripts', 'genesis_sample_enqueue_scripts_styles' );
/**
 * Enqueues scripts and styles.
 *
 * @since 1.0.0
 */
function genesis_sample_enqueue_scripts_styles() {
    
    wp_enqueue_style( 'bootstrap-min', '//maxcdn.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css');
    wp_enqueue_style( 'main-style', get_stylesheet_uri() );
    wp_enqueue_script( 'header-scroll', get_bloginfo( 'stylesheet_directory' ) . '/js/header-scroll.js', array( 'jquery' ), '1.0.0' );
    wp_enqueue_style( 'lato', '//fonts.googleapis.com/css?family=Lato:300,400,700,900');
    wp_enqueue_style( 'open-sans', '//fonts.googleapis.com/css?family=Open+Sans:300,400,700,800');
    wp_enqueue_style( 'font-awesome', 'https://use.fontawesome.com/releases/v5.11.2/css/all.css');
    wp_enqueue_script('bootstrap-js', '//maxcdn.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js');

	$appearance = genesis_get_config( 'appearance' );

	wp_enqueue_style(
		genesis_get_theme_handle() . '-fonts',
		$appearance['fonts-url'],
		[],
		genesis_get_theme_version()
	);

	wp_enqueue_style( 'dashicons' );

	if ( genesis_is_amp() ) {
		wp_enqueue_style(
			genesis_get_theme_handle() . '-amp',
			get_stylesheet_directory_uri() . '/lib/amp/amp.css',
			[ genesis_get_theme_handle() ],
			genesis_get_theme_version()
		);
	}

}

add_action( 'after_setup_theme', 'genesis_sample_theme_support', 9 );
/**
 * Add desired theme supports.
 *
 * See config file at `config/theme-supports.php`.
 *
 * @since 3.0.0
 */
function genesis_sample_theme_support() {

	$theme_supports = genesis_get_config( 'theme-supports' );

	foreach ( $theme_supports as $feature => $args ) {
		add_theme_support( $feature, $args );
	}

}

add_action( 'after_setup_theme', 'genesis_sample_post_type_support', 9 );
/**
 * Add desired post type supports.
 *
 * See config file at `config/post-type-supports.php`.
 *
 * @since 3.0.0
 */
function genesis_sample_post_type_support() {

	$post_type_supports = genesis_get_config( 'post-type-supports' );

	foreach ( $post_type_supports as $post_type => $args ) {
		add_post_type_support( $post_type, $args );
	}

}

// Adds image sizes.
add_image_size( 'sidebar-featured', 75, 75, true );
add_image_size( 'genesis-singular-images', 702, 526, true );

// Removes header right widget area.
unregister_sidebar( 'header-right' );

// Removes secondary sidebar.
unregister_sidebar( 'sidebar-alt' );

// Removes site layouts.
genesis_unregister_layout( 'content-sidebar-sidebar' );
genesis_unregister_layout( 'sidebar-content-sidebar' );
genesis_unregister_layout( 'sidebar-sidebar-content' );

// Repositions primary navigation menu.
remove_action( 'genesis_after_header', 'genesis_do_nav' );
add_action( 'genesis_header', 'genesis_do_nav', 12 );

// Repositions the secondary navigation menu.
remove_action( 'genesis_after_header', 'genesis_do_subnav' );
add_action( 'genesis_footer', 'genesis_do_subnav', 10 );

add_filter( 'wp_nav_menu_args', 'genesis_sample_secondary_menu_args' );
/**
 * Reduces secondary navigation menu to one level depth.
 *
 * @since 2.2.3
 *
 * @param array $args Original menu options.
 * @return array Menu options with depth set to 1.
 */
function genesis_sample_secondary_menu_args( $args ) {

	if ( 'secondary' === $args['theme_location'] ) {
		$args['depth'] = 1;
	}

	return $args;

}

add_filter( 'genesis_author_box_gravatar_size', 'genesis_sample_author_box_gravatar' );
/**
 * Modifies size of the Gravatar in the author box.
 *
 * @since 2.2.3
 *
 * @param int $size Original icon size.
 * @return int Modified icon size.
 */
function genesis_sample_author_box_gravatar( $size ) {

	return 90;

}

add_filter( 'genesis_comment_list_args', 'genesis_sample_comments_gravatar' );
/**
 * Modifies size of the Gravatar in the entry comments.
 *
 * @since 2.2.3
 *
 * @param array $args Gravatar settings.
 * @return array Gravatar settings with modified size.
 */
function genesis_sample_comments_gravatar( $args ) {

	$args['avatar_size'] = 60;
	return $args;

}

// Changes post dates from date to days ago
add_filter( 'get_the_date', 'meks_convert_to_time_ago', 10, 1 ); //override date display
add_filter( 'the_date', 'meks_convert_to_time_ago', 10, 1 ); //override date display
add_filter( 'get_the_time', 'meks_convert_to_time_ago', 10, 1 ); //override time display
add_filter( 'the_time', 'meks_convert_to_time_ago', 10, 1 ); //override time display
 
/* Callback function for post time and date filter hooks */
function meks_convert_to_time_ago( $orig_time ) {
	global $post;
	$orig_time = strtotime( $post->post_date ); 
	return human_time_diff( $orig_time, current_time( 'timestamp' ) ).' '.__( 'ago' );
}

// ACF Gutenberg Blocks
function register_acf_block_types() {
  
    acf_register_block_type(array(
        'name'              => 'full-width-cta-block',
        'title'             => __('Full Width CTA Block'),
        'description'       => __('This adds a Full Width CTA block to a page.'),
        'render_template'   => 'acf-blocks/full-width-cta-block.php',
        'category'          => 'bw-blocks',
        'icon'              => 'megaphone',
        'keywords'          => array( 'cta' ),

    ));
    
    acf_register_block_type(array(
        'name'              => 'related-posts-block',
        'title'             => __('Related Posts Block'),
        'description'       => __('This adds a Related Posts block to a page.'),
        'render_template'   => 'acf-blocks/related-post-block.php',
        'category'          => 'bw-blocks',
        'icon'              => 'images-alt2',
        'keywords'          => array( 'related' ),
        'mode' => 'edit',
        'supports' => array( 'mode' => true ),

    ));
    
    acf_register_block_type(array(
        'name'              => 'faq-block',
        'title'             => __('FAQ Block'),
        'description'       => __('This adds a FAQ block to a page.'),
        'render_template'   => 'acf-blocks/faq-block.php',
        'category'          => 'bw-blocks',
        'icon'              => 'editor-help',
        'keywords'          => array( 'related' ),
        'mode' => 'edit',
        'supports' => array( 'mode' => true ),
    ));
    
}

// Check if function exists and hook into setup.
if( function_exists('acf_register_block_type') ) {
    add_action('acf/init', 'register_acf_block_types');
}

// This creates a Block Category called Wayzata Blocks so we can organize the custom blocks.
function bw_block_category( $categories, $post ) {
	return array_merge(
		$categories,
		array(
			array(
				'slug' => 'bw-blocks',
				'title' => __( 'BizzyWeb Blocks', 'bw-blocks' ),
			),
		)
	);
}
add_filter( 'block_categories', 'bw_block_category', 10, 2);

// This function converts the ACF color picker hex value to RGB
function hex2rgbwed_events($hex) {
    $hex = str_replace("#", "", $hex);

    if(strlen($hex) == 3) {
        $r = hexdec(substr($hex,0,1).substr($hex,0,1));
        $g = hexdec(substr($hex,1,1).substr($hex,1,1));
        $b = hexdec(substr($hex,2,1).substr($hex,2,1));
    } else {
        $r = hexdec(substr($hex,0,2));
        $g = hexdec(substr($hex,2,2));
        $b = hexdec(substr($hex,4,2));
    }
    $rgb = array($r, $g, $b);
          
    return $rgb; // returns an array with the rgb values

}

//* This removes the default color palette and color picker
function wpdc_disable_gutenberg_colour_settings() {
	add_theme_support( 'disable-custom-colors' );
	add_theme_support( 'editor-color-palette' );
}
add_action( 'after_setup_theme', 'wpdc_disable_gutenberg_colour_settings' );

//* This adds custom colors to blocks
function wpdc_add_custom_gutenberg_color_palette() {
	add_theme_support(
		'editor-color-palette',
		[
			[
				'name'  => esc_html__( 'Red', 'heartcert' ),
				'slug'  => 'red',
				'color' => '#a61c41',
			],
			[
				'name'  => esc_html__( 'Orange', 'heartcert' ),
				'slug'  => 'orange',
				'color' => '#f2921d',
			],
			[
				'name'  => esc_html__( 'Light Blue', 'heartcert' ),
				'slug'  => 'light-blue',
				'color' => '#0c80a6',
			],
			[
				'name'  => esc_html__( 'Dark Blue', 'heartcert' ),
				'slug'  => 'dark-blue',
				'color' => '#0b4659',
			],
			[
				'name'  => esc_html__( 'Light Gray', 'heartcert' ),
				'slug'  => 'light-gray',
				'color' => '#f2f2f2',
			],
			[
				'name'  => esc_html__( 'Black', 'heartcert' ),
				'slug'  => 'black',
				'color' => '#2f3430',
			],
		]
	);
}
add_action( 'after_setup_theme', 'wpdc_add_custom_gutenberg_color_palette' );

//* Function for Gravity Form Two Columns

function gform_column_splits( $content, $field, $value, $lead_id, $form_id ) {
	if( !IS_ADMIN ) { // only perform on the front end

		// target section breaks
		if( $field['type'] == 'section' ) {
			$form = RGFormsModel::get_form_meta( $form_id, true );

			// check for the presence of multi-column form classes
			$form_class = explode( ' ', $form['cssClass'] );
			$form_class_matches = array_intersect( $form_class, array( 'two-column', 'three-column' ) );

			// check for the presence of section break column classes
			$field_class = explode( ' ', $field['cssClass'] );
			$field_class_matches = array_intersect( $field_class, array('gform_column') );

			// if field is a column break in a multi-column form, perform the list split
			if( !empty( $form_class_matches ) && !empty( $field_class_matches ) ) { // make sure to target only multi-column forms

				// retrieve the form's field list classes for consistency
				$form = RGFormsModel::add_default_properties( $form );
				$description_class = rgar( $form, 'descriptionPlacement' ) == 'above' ? 'description_above' : 'description_below';

				// close current field's li and ul and begin a new list with the same form field list classes
				return '</li></ul><ul class="gform_fields '.$form['labelPlacement'].' '.$description_class.' '.$field['cssClass'].'"><li class="gfield gsection empty">';

			}
		}
	}

	return $content;
}
add_filter( 'gform_field_content', 'gform_column_splits', 10, 5 );

//* Arrows in Main Menu

function be_arrows_in_menus( $item_output, $item, $depth, $args ) {
	if( in_array( 'menu-item-has-children', $item->classes ) ) {
		$arrow = 0 == $depth ? '<i class="fa fa-angle-down"></i>' : '<i class="fa fa-angle-right"></i>';
		$item_output = str_replace( '</a>', $arrow . '</a>', $item_output );
	}
	return $item_output;
}
add_filter( 'walker_nav_menu_start_el', 'be_arrows_in_menus', 10, 4 );

//* Adds rel=0 to the YouTube embed block
function wpftw_modest_youtube_player( $block_content, $block ) {
  if( ( "core-embed/youtube" === $block['blockName'] ) || ( "core/embed" === $block['blockName'] ) ) {
    $block_content = str_replace( '?feature=oembed', '?feature=oembed&modestbranding=1&showinfo=0&rel=0', $block_content );
  }
  return $block_content;
}
add_filter( 'render_block', 'wpftw_modest_youtube_player', 10, 3);