## [3.1.0] - 2019-08-21

Requires PHP 5.6+ and WordPress 5.0+.

### Added
* Theme support: Add `genesis-custom-logo` theme support for logo output. This enables logo upload in the Site Identity section, outputs a logo, and improves accessibility of the site title.
* Customizer: Add a footer text option under Theme Settings -> Footer.
* Customizer: Add new Singular Content section to hold settings specific to posts, pages and other post types.
* Editor: Add a new Genesis sidebar for sites that use the block editor.
* Editor: Add a “hide breadcrumbs” checkbox to the Genesis sidebar in the block editor.
* Editor: Add a “hide title” checkbox to the Genesis sidebar in the block editor.
* Editor: Add a “hide featured image” checkbox to the Genesis sidebar in the block editor.
* Editor: Add status info to the Breadcrumbs panel to show global status of breadcrumbs for the current post type (requires the `edit-theme-options` capability and `genesis-breadcrumbs-toggle` post type support).
* Editor: Add status info to the Images panel to show global status of featured images for the current post type (requires the `edit-theme-options` capability and `genesis-singular-images` post type support).
* Editor: Add link to the Breadcrumbs panel to toggle breadcrumbs on and off globally for the current post type (requires the `edit-theme-options` capability and `genesis-breadcrumbs-toggle` post type support).
* Editor: Add link to the Images panel to toggle featured images on and off globally for the current post type (requires the `edit-theme-options` capability and `genesis-singular-images` post type support).
* Schema: Suppress output of Genesis schema if Yoast SEO is outputting JSON-LD markup.
* Schema: developers can disable schema with `add_filter( 'genesis_disable_microdata', '__return_true' );`.
* Post type support: Add `genesis-singular-images` post type support to enable output of featured images, and a related output setting in the new Singular Content Customizer panel.
* Post type support: Add `genesis-breadcrumbs-toggle` post type support to control which post types support the “hide breadcrumbs” checkbox.
* Post type support: Add `genesis-title-toggle` post type support to control which post types support the “hide title” checkbox.
* CSS: Add 'genesis-title-hidden' body class if the “hide title” checkbox is enabled.
* Theme setup: add option to import widgets during one-click theme setup. See Genesis Sample's `onboarding.php` for an up-to-date usage example.
* Theme setup: Add Starter Packs feature. Theme developers can now offer users a choice of content and plugin packs during theme setup. See Genesis Sample's `onboarding.php` for an up-to-date usage example.
* Theme setup: Add Child Theme Setup menu item to the Genesis admin menu to make finding the Getting Started page again easier for active themes that support one-click theme setup.
* REST API: Genesis now exposes hide title and hide breadcrumbs state, page layout, and custom body and post class via the `meta` field in the `posts` endpoint: `/wp-json/wp/v2/posts/[id]`
* REST API: Genesis now exposes supported layouts for the active theme via a new `layouts` endpoint: `/wp-json/genesis/v1/layouts/site`.
* Tooling: use the `@wordpress/scripts` package to build ES2015+ and React code.

### Removed
* SEO: Remove `noodp` and `noydir` settings. The Yahoo! Directory (the `ydir` in `noydir`) closed in 2014. The Open Directory Project (the `odp` in `noodp`) closed in 2017. Related settings are also removed from the database during upgrade.
* Deprecation: The `genesis_footer_creds_text` filter is now deprecated. Developers can point users who want to edit their footer text to the new Genesis footer setting in the Customizer. If you want to set default footer text for your child theme during theme activation, you should set the `footer_text key` in your theme’s `child-theme-settings.php` file.
* Tooling: remove the `phpcs-fixed` command. Genesis now runs `phpcs` against all files instead of a subset of known-good files.

### Changed
* Code: Switch to PHP short array syntax and enforce this via `phpcs.xml.dist`.
* Translation: Remove HTML from translated strings where possible.
* Tooling: language files are now generated with WP-CLI. This ensures strings in JavaScript files are now captured.
* Documentation: Add link to the Genesis developer documentation site to the readme.
* Theme setup: create new menus during one-click theme setup instead of appending menu items to existing menus.
* SEO: The Genesis SEO “Primary Title H1” setting will now apply on static homepages.
* Accessibility: Change skip link text from “Skip to content” to “Skip to main content” to improve pronunciation of “content” by screen readers.
* Customizer: Update text in the Theme Settings -> Updates panel to clarify what site data is sent during update requests and link to the privacy policy.

### Fixed
* Standards: Remove an unneeded argument when calling `genesis_onboarding_import_content()`.
* Standards: Address all PHP_CodeSniffer coding standards violations.
* Standards: Fix a warning that could appear during update if Genesis Simple Sidebars was in use.
* Tooling: Correct an issue where PHP_CodeSniffer extensions for VS Code and Atom users would fail to run.
* Translation: Correct missing translators comments and correct numbered placeholders.
* Translation: Fix translators comments that differed for the same string.
* Breadcrumbs: Ensure “Breadcrumbs on Homepage” enables breadcrumbs on static homepages. Previously “Breadcrumbs on Pages” also had to be checked.
* General: `genesis_get_global_post_type_name()` will now return the correct post type if the main query has been filtered to show additional post types.

[3.1.0]: https://github.com/studiopress/genesis/compare/3.0.3...3.1.0
