<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package StudioPress\Genesis
 * @author  StudioPress
 * @license GPL-2.0-or-later
 * @link    https://my.studiopress.com/themes/genesis/
 */

?>
<h3><?php esc_html_e( 'How Home Pages Work', 'genesis' ); ?></h3>
<p>
	<?php esc_html_e( 'Most Genesis child themes include a custom home page.', 'genesis' ); ?>
</p>
<p>
	<?php esc_html_e( 'To use this type of home page, make sure your latest posts are set to show on the front page. You can setup a page with the Blog page template to show a blog style list of your latest posts on another page.', 'genesis' ); ?>
</p>
<p>
	<?php esc_html_e( 'This home page is typically setup via widgets in the sidebars for the home page. This can be accessed via the Widgets menu item under Appearance.', 'genesis' ); ?>
</p>
<p>
	<?php esc_html_e( 'Child themes that include this type of home page typically include additional theme-specific tutorials which can be accessed via a sticky post at the top of that child theme support forum.', 'genesis' ); ?>
</p>
<p>
	<?php esc_html_e( 'If your theme uses a custom home page and you want to show the latest posts in a blog format, do not use the blog template. Instead, you need to rename the home.php file to home-old.php instead.', 'genesis' ); ?>
</p>
<p>
	<?php esc_html_e( 'Another common home page is the "blog" type home page, which is common to most of the free child themes. This shows your latest posts and requires no additional setup.', 'genesis' ); ?>
</p>
<p>
	<?php esc_html_e( 'The third type of home page is the new dynamic home page. This is common on the newest child themes. It will show your latest posts in a blog type listing unless you put widgets into the home page sidebars.', 'genesis' ); ?>
</p>
<p>
	<?php esc_html_e( 'This setup is preferred because it makes it easier to show a blog on the front page (no need to rename the home.php file) and does not have the confusion of no content on the home page when the theme is initially installed.', 'genesis' ); ?>
</p>
