<?php

/**
 * Class dealing with anonymizing and removing user data..
 *
 * @link       https://gdprdemo.willowdigital.com/
 * @since      1.0.0
 *
 * @package    Gdpr_Personal_Data_Reports
 * @subpackage Gdpr_Personal_Data_Reports/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Gdpr_Personal_Data_Reports
 * @subpackage Gdpr_Personal_Data_Reports/public
 * @author     Wojtek Murawski <wojtek@willowsconsulting.ie>
 */
class Gdpr_Personal_Data_Reports_Remover {

  private $wpdb;
  private $table_name;
  public $status_unconfirmed = 0;
  public $status_confirmed = 1;
  public $status_emailed = 2;
  public $status_completed = 3;

  public function __construct($gdpr_personal_data_reports)
  {
    global $wpdb;
    $this->wpdb = $wpdb;
    $this->table_name = $this->wpdb->prefix . 'gdpr_requests';
    $this->gdpr_personal_data_reports = $gdpr_personal_data_reports;
  }

  /**
   * Anonymize user data. Turns all personal data in the users table into
   * randomized strings
   * @param  [int] $user_id
   */
  public function anonymize_user_data($user_id)
  {
    // Get existing user data
    $query = "SELECT * FROM " . $this->wpdb->users . " WHERE ID = '" . $user_id . "'";
    $user = $this->wpdb->get_row($query);

    // Anonymize
    $a_user_login = $this->garble($user->user_login);
    $a_user_nicename = $this->garble($user->user_nicename);
    $a_user_email = $this->garble($user->user_email);
    $a_user_display_name = $this->garble($user->display_name);

    // Update user record with the garbled data
    $this->wpdb->update($this->wpdb->users,
    array(
      'user_login' => $a_user_login,
      'user_nicename' => $a_user_nicename,
      'user_email' => $a_user_email,
      'display_name' => $a_user_display_name,
    ),
    array('ID' => $user_id));
  }

  /**
   * Delete GDPR Requests by email. Requests of type 2 (forget me) are excluded
   * @param  [string] $email
   */
  public function delete_gdpr_requests($email)
  {
    $query = $this->wpdb->prepare( "DELETE FROM $this->table_name WHERE email = %s AND request_type NOT LIKE 2", array( $email ) );
    $this->wpdb->query($query);
  }

  /**
   * Delete user metadate by user ID
   * @param  [int] $user_id
   */
  public function delete_user_metadata($user_id)
  {
    $query = $this->wpdb->prepare( "DELETE FROM " . $this->wpdb->usermeta . " WHERE user_id = %d", array( $user_id ) );
    $this->wpdb->query($query);
  }

  /**
   * Turn a string into a random set of characters
   * @param  [string] $text [string to garble]
   * @return [string]       [garbled/anonymized string]
   */
  public function garble($text)
  {
    $random_string = '';
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $characters_length = strlen($characters);
    $text_length = strlen($text);
    for ($i = 0; $i < $text_length; $i++) {
        $random_string .= $characters[rand(0, $characters_length - 1)];
    }
    return $random_string;
  }

}
